"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.internalUpdateWhere = exports.updateWhere = void 0;
const Middleware_1 = require("../events/Middleware");
const query_1 = require("../query");
const createDB_1 = require("./createDB");
const errors_1 = require("./errors");
const table_utils_1 = require("./table.utils");
const updateMany_1 = require("./updateMany");
/**
 * Modifies all entities that match the given `filter` using the provided `callback`.
 *
 * @throws if the primary key of an entity is modified in the `callback`.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const userId = await insert(userTable, { id: uuid(), name: 'Alice', age: 20 });
 * // Happy Birthday! Increase the age of all 20 year olds to 21
 * await updateWhere(userTable, { where: { age: 20 } }, (user) => {
 *   return { ...user, age: user.age + 1 };
 * });
 */
function updateWhere(table, filter, callback) {
    return Promise.resolve((0, Middleware_1.middleware)(table, { action: "updateWhere", params: [table, filter, callback] }, (table, filter, callback) => internalUpdateWhere(table, filter, callback)));
}
exports.updateWhere = updateWhere;
function internalUpdateWhere(table, filter, callback) {
    const primaryKeyProperty = table[createDB_1.BlinkKey].options.primary;
    let items = (0, query_1.get)(table, filter);
    items = table_utils_1.TableUtils.cloneIfNecessary(table, items);
    return Promise.all(items.map((item) => __awaiter(this, void 0, void 0, function* () {
        const newItem = yield callback(item);
        if (newItem[primaryKeyProperty] !== item[primaryKeyProperty]) {
            throw new errors_1.PrimaryKeyCannotBeModifiedError(item[primaryKeyProperty]);
        }
        return newItem;
    })))
        .then((modifiedItems) => (0, updateMany_1.internalUpdateMany)(table, modifiedItems))
        .then((_) => { });
}
exports.internalUpdateWhere = internalUpdateWhere;
