import { Filter } from "../query/types";
import { Entity, PrimaryKeyOf } from "../types";
import { Table } from "./createTable";
import { Diff } from "./update";
/**
 * Modifies all entities that match the given `filter` using the provided `callback`.
 *
 * @throws if the primary key of an entity is modified in the `callback`.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const userId = await insert(userTable, { id: uuid(), name: 'Alice', age: 20 });
 * // Happy Birthday! Increase the age of all 20 year olds to 21
 * await updateWhere(userTable, { where: { age: 20 } }, (user) => {
 *   return { ...user, age: user.age + 1 };
 * });
 */
export declare function updateWhere<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, filter: Filter<T>, callback: (item: T) => Diff<T, P> | Promise<Diff<T, P>>): Promise<void>;
export declare function internalUpdateWhere<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, filter: Filter<T>, callback: (item: T) => Diff<T, P> | Promise<Diff<T, P>>): Promise<void>;
