import { Entity, PrimaryKeyOf } from "../types";
import { Table } from "./createTable";
import { Diff } from "./update";
/**
 * Saves updates of the given entities in the `table`.
 *
 * @throws if one of the entities has not been inserted into the table before,
 * e.g. if the primary key of the entity was not found.
 *
 * @returns the primary key of the updated entities,
 * in the same order as the items.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const aliceId = await insert(userTable, { id: uuid(), name: 'Alice', age: 15 });
 * const bobId = await insert(userTable, { id: uuid(), name: "Bob", age: 45 });
 * // Increase the age of Alice
 * await updateMany(userTable, [
 *   { id: aliceId, age: 16 },
 *   { id: bobId, age: 45 }
 * ]);
 */
export declare function updateMany<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, diffs: Diff<T, P>[]): Promise<T[P][]>;
export declare function internalUpdateMany<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, diffs: Diff<T, P>[]): Promise<T[P][]>;
