"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.internalUpdate = exports.update = void 0;
const Middleware_1 = require("../events/Middleware");
const updateMany_1 = require("./updateMany");
/**
 * Saves updates of the given `entity` in `table`.
 *
 * @throws if the entity has not been inserted into the table before, e.g. if the primary key of the entity was not found.
 *
 * @returns the primary key of the updated entity.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const userId = await insert(userTable, { id: uuid(), name: 'Alice', age: 15 });
 * // Increase the age of Alice
 * await update(userTable, { id: userId, age: 16 });
 */
function update(table, diff) {
    return Promise.resolve((0, Middleware_1.middleware)(table, { action: "update", params: [table, diff] }, (table, diff) => internalUpdate(table, diff)));
}
exports.update = update;
function internalUpdate(table, diff) {
    return (0, updateMany_1.internalUpdateMany)(table, [diff]).then((ids) => ids[0]);
}
exports.internalUpdate = internalUpdate;
