import { Entity, PrimaryKeyOf } from "../types";
import { Table } from "./createTable";
/**
 * Saves updates of the given `entity` in `table`.
 *
 * @throws if the entity has not been inserted into the table before, e.g. if the primary key of the entity was not found.
 *
 * @returns the primary key of the updated entity.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const userId = await insert(userTable, { id: uuid(), name: 'Alice', age: 15 });
 * // Increase the age of Alice
 * await update(userTable, { id: userId, age: 16 });
 */
export declare function update<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, diff: Diff<T, P>): Promise<T[P]>;
export declare function internalUpdate<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, diff: Diff<T, P>): Promise<T[P]>;
export declare type Diff<T extends Entity<T>, P extends PrimaryKeyOf<T>> = Partial<T> & {
    [Key in P]: T[P];
};
