"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableUtils = void 0;
const clone_1 = require("./clone");
const createDB_1 = require("./createDB");
var TableUtils;
(function (TableUtils) {
    /**
     * Clones the supplied object if `clone = true` was passed
     * when the database of the table was created with `createDB()`.
     */
    function cloneIfNecessary(table, obj) {
        return table[createDB_1.BlinkKey].db[createDB_1.BlinkKey].options.clone ? (0, clone_1.clone)(obj) : obj;
    }
    TableUtils.cloneIfNecessary = cloneIfNecessary;
})(TableUtils = exports.TableUtils || (exports.TableUtils = {}));
