"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.internalRemoveWhere = exports.removeWhere = void 0;
const Middleware_1 = require("../events/Middleware");
const query_1 = require("../query");
const removeMany_1 = require("./removeMany");
/**
 * Removes all entities that match the given `filter`.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const userId = await insert(userTable, { id: uuid(), name: 'Alice', age: 15 });
 * // Remove all users older than 15
 * await removeWhere(userTable, {
 *   where: {
 *     age: { gt: 15 }
 *   }
 * });
 */
function removeWhere(table, filter) {
    return Promise.resolve((0, Middleware_1.middleware)(table, { action: "removeWhere", params: [table, filter] }, (table, filter) => internalRemoveWhere(table, filter)));
}
exports.removeWhere = removeWhere;
function internalRemoveWhere(table, filter) {
    return (0, removeMany_1.internalRemoveMany)(table, (0, query_1.get)(table, filter)).then((_) => { });
}
exports.internalRemoveWhere = internalRemoveWhere;
