import { Filter } from "../query/types";
import { Entity, PrimaryKeyOf } from "../types";
import { Table } from "./createTable";
/**
 * Removes all entities that match the given `filter`.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const userId = await insert(userTable, { id: uuid(), name: 'Alice', age: 15 });
 * // Remove all users older than 15
 * await removeWhere(userTable, {
 *   where: {
 *     age: { gt: 15 }
 *   }
 * });
 */
export declare function removeWhere<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, filter: Filter<T>): Promise<void>;
export declare function internalRemoveWhere<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, filter: Filter<T>): Promise<void>;
