import { Entity, PrimaryKeyOf } from "../types";
import { Table } from "./createTable";
import { Ids } from "./remove";
/**
 * Removes the given `entities` from the `table`.
 *
 * @returns the number of removed entities.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const userId = await insert(userTable, { id: uuid(), name: 'Alice', age: 15 });
 * // Remove Alice from the table
 * await remove(userTable, { id: userId });
 */
export declare function removeMany<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, entities: Ids<T, P>[]): Promise<number>;
export declare function internalRemoveMany<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, entities: Ids<T, P>[]): Promise<number>;
