"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.internalRemove = exports.remove = void 0;
const Middleware_1 = require("../events/Middleware");
const removeMany_1 = require("./removeMany");
/**
 * Removes a given `entity` from the `table`.
 *
 * @returns true if the entity was found and removed, false otherwise.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const userId = await insert(userTable, { id: uuid(), name: 'Alice', age: 15 });
 * // Remove Alice from the table
 * await remove(userTable, { id: userId });
 */
function remove(table, entity) {
    return Promise.resolve((0, Middleware_1.middleware)(table, { action: "remove", params: [table, entity] }, (table, entity) => internalRemove(table, entity)));
}
exports.remove = remove;
function internalRemove(table, entity) {
    return (0, removeMany_1.internalRemoveMany)(table, [entity]).then((n) => n === 1);
}
exports.internalRemove = internalRemove;
