import { Entity, PrimaryKeyOf } from "../types";
import { Table } from "./createTable";
/**
 * Removes a given `entity` from the `table`.
 *
 * @returns true if the entity was found and removed, false otherwise.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const userId = await insert(userTable, { id: uuid(), name: 'Alice', age: 15 });
 * // Remove Alice from the table
 * await remove(userTable, { id: userId });
 */
export declare function remove<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, entity: Ids<T, P>): Promise<boolean>;
export declare function internalRemove<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, entity: Ids<T, P>): Promise<boolean>;
/**
 * Only primary key properties of T
 */
export declare type Ids<T extends Entity<T>, P extends PrimaryKeyOf<T>> = {
    [K in P]: T[P];
};
