"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.internalOne = exports.one = void 0;
const Middleware_1 = require("../events/Middleware");
const query_1 = require("../query");
const createDB_1 = require("./createDB");
const errors_1 = require("./errors");
const table_utils_1 = require("./table.utils");
function one(table, queryOrId) {
    return Promise.resolve((0, Middleware_1.middleware)(table, { action: "one", params: [table, queryOrId] }, (table, query) => internalOne(table, query)));
}
exports.one = one;
function internalOne(table, queryOrId) {
    var _a;
    if (typeof queryOrId !== "object") {
        let entity = (_a = table[createDB_1.BlinkKey].storage.primary.get(queryOrId)) !== null && _a !== void 0 ? _a : null;
        if (entity === null) {
            return Promise.reject(new errors_1.ItemNotFoundError(queryOrId));
        }
        return Promise.resolve(table_utils_1.TableUtils.cloneIfNecessary(table, entity));
    }
    const res = (0, query_1.get)(table, queryOrId);
    if (res.length === 0) {
        return Promise.reject(new errors_1.ItemNotFoundError(queryOrId));
    }
    else if (res.length > 1) {
        return Promise.reject(new errors_1.MoreThanOneItemFoundError(queryOrId));
    }
    return Promise.resolve(table_utils_1.TableUtils.cloneIfNecessary(table, res[0]));
}
exports.internalOne = internalOne;
