import { Query } from "../query/types";
import { Entity, PrimaryKeyOf } from "../types";
import { Table } from "./createTable";
/**
 * Retrieves the entity from `table` matching the given `id`.
 *
 * @throws if no item matches the given id.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * // Retrieve the user with id 10
 * const userWithId = await one(userTable, 10);
 */
export declare function one<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, id: T[P]): Promise<T>;
/**
 * Retrieves the entity from `table` matching the given `filter`.
 *
 * @throws if no item or more than one item matches the filter.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * // Retrieve the user with id 10
 * const userWithId = await one(userTable, { where: { id: 10 } });
 */
export declare function one<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, query: Query<T, P>): Promise<T>;
export declare function internalOne<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, queryOrId: Query<T, P> | T[P]): Promise<T>;
