"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.internalMany = exports.many = void 0;
const Middleware_1 = require("../events/Middleware");
const query_1 = require("../query");
const createDB_1 = require("./createDB");
const table_utils_1 = require("./table.utils");
function many(table, query) {
    return Promise.resolve((0, Middleware_1.middleware)(table, { action: "many", params: [table, query] }, (table, query) => internalMany(table, query)));
}
exports.many = many;
function internalMany(table, query) {
    if (query === undefined) {
        const allItems = table[createDB_1.BlinkKey].storage.primary.valuesArray();
        return Promise.resolve(table_utils_1.TableUtils.cloneIfNecessary(table, allItems));
    }
    const items = (0, query_1.get)(table, query);
    return Promise.resolve(table_utils_1.TableUtils.cloneIfNecessary(table, items));
}
exports.internalMany = internalMany;
