import { Query } from "../query/types";
import { Entity, PrimaryKeyOf } from "../types";
import { Table } from "./createTable";
/**
 * Retrieve all entities from `table`.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const allUsers = await many(userTable);
 */
export declare function many<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>): Promise<T[]>;
/**
 * Retrieve all entities from `table` that match the given `filter`.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * // All users called 'Alice'
 * const allUsersNamedAlice = await many(userTable, {
 *   where: {
 *     name: "Alice"
 *   }
 * });
 * // All users aged 25 and up
 * const allUsersOlderThan25 = await many(userTable, {
 *   where: {
 *     age: { gt: 25 }
 *   }
 * });
 */
export declare function many<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, query?: Query<T, P>): Promise<T[]>;
export declare function internalMany<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, query?: Query<T, P>): Promise<T[]>;
