"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.key = void 0;
const createDB_1 = require("./createDB");
function key(table, item) {
    const primaryKeyProperty = table[createDB_1.BlinkKey].options.primary;
    if (item === undefined) {
        return primaryKeyProperty;
    }
    else if (isPromise(item)) {
        return item.then((item) => {
            if (Array.isArray(item)) {
                return item.map((item) => item[primaryKeyProperty]);
            }
            else {
                return item[primaryKeyProperty];
            }
        });
    }
    else if (Array.isArray(item)) {
        return item.map((item) => item[primaryKeyProperty]);
    }
    else {
        return item[primaryKeyProperty];
    }
}
exports.key = key;
function isPromise(val) {
    return "then" in val && typeof val.then === "function";
}
