import { Entity, PrimaryKeyOf } from "../types";
import { Table } from "./createTable";
/**
 * Inserts new entities into `table`.
 *
 * @returns the primary key of the inserted entities,
 * in the same order as the items.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const [aliceId, bobId, charlieId] = await insertMany(userTable, [
 *   { id: uuid(), name: "Alice", age: 23 },
 *   { id: uuid(), name: "Bob", age: 45 },
 *   { id: uuid(), name: "Charlie", age: 34 }
 * ]);
 */
export declare function insertMany<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, entities: T[]): Promise<T[P][]>;
export declare function internalInsertMany<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, entities: T[]): Promise<T[P][]>;
