"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.internalInsert = exports.insert = void 0;
const Middleware_1 = require("../events/Middleware");
const insertMany_1 = require("./insertMany");
/**
 * Inserts a new entity into `table`.
 *
 * @returns the primary key of the inserted entity.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const aliceId = await insert(userTable, { id: uuid(), name: "Alice", age: 23 });
 * const bobId = await insert(userTable, { id: uuid(), name: "Bob", age: 45 });
 * const charlieId = await insert(userTable, { id: uuid(), name: "Charlie", age: 34 });
 */
function insert(table, entity) {
    return Promise.resolve((0, Middleware_1.middleware)(table, { action: "insert", params: [table, entity] }, (table, entity) => internalInsert(table, entity)));
}
exports.insert = insert;
function internalInsert(table, entity) {
    return (0, insertMany_1.internalInsertMany)(table, [entity]).then((ids) => ids[0]);
}
exports.internalInsert = internalInsert;
