"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.internalFirst = exports.first = void 0;
const Middleware_1 = require("../events/Middleware");
const query_1 = require("../query");
const createDB_1 = require("./createDB");
const table_utils_1 = require("./table.utils");
function first(table, queryOrId) {
    return Promise.resolve((0, Middleware_1.middleware)(table, { action: "first", params: [table, queryOrId] }, (table, query) => internalFirst(table, query)));
}
exports.first = first;
function internalFirst(table, queryOrId) {
    var _a, _b;
    if (queryOrId === undefined) {
        const btree = table[createDB_1.BlinkKey].storage.primary;
        const minKey = btree.minKey();
        const entity = minKey ? (_a = btree.get(minKey)) !== null && _a !== void 0 ? _a : null : null;
        return Promise.resolve(table_utils_1.TableUtils.cloneIfNecessary(table, entity));
    }
    else if (typeof queryOrId !== "object") {
        const entity = (_b = table[createDB_1.BlinkKey].storage.primary.get(queryOrId)) !== null && _b !== void 0 ? _b : null;
        return Promise.resolve(table_utils_1.TableUtils.cloneIfNecessary(table, entity));
    }
    const res = (0, query_1.get)(table, queryOrId);
    if (!res[0]) {
        return Promise.resolve(null);
    }
    return Promise.resolve(table_utils_1.TableUtils.cloneIfNecessary(table, res[0]));
}
exports.internalFirst = internalFirst;
