import { Query } from "../query/types";
import { Entity, PrimaryKeyOf } from "../types";
import { Table } from "./createTable";
/**
 * Retrieves the first entity from `table`.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * // Retrieve the first user
 * const firstUser = await first(userTable);
 */
export declare function first<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>): Promise<T | null>;
/**
 * Retrieves the first entity from `table` matching the given `filter`.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * // Retrieve the first user named 'Alice'
 * const firstUser = await first(userTable, { where: { name: "Alice" } });
 */
export declare function first<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, query: Query<T, P>): Promise<T | null>;
/**
 * Retrieves the first entity from `table` with the given `id`.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * // Retrieve the 'Alice' user by their id
 * const firstUser = await first(userTable, 'alice-uuid');
 */
export declare function first<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, id: T[P]): Promise<T | null>;
export declare function internalFirst<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, queryOrId?: Query<T, P> | T[P]): Promise<T | null>;
