"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MoreThanOneItemFoundError = exports.ItemNotFoundError = exports.PrimaryKeyCannotBeModifiedError = exports.InvalidPrimaryKeyError = exports.PrimaryKeyAlreadyInUseError = void 0;
/**
 * Thrown if the primary key of an item being inserted is already present within the table.
 */
class PrimaryKeyAlreadyInUseError extends Error {
    constructor(primaryKey) {
        super(`Primary key "${primaryKey}" already in use.`);
        this.primaryKey = primaryKey;
    }
}
exports.PrimaryKeyAlreadyInUseError = PrimaryKeyAlreadyInUseError;
/**
 * Thrown if an invalid value is given as a primary key.
 */
class InvalidPrimaryKeyError extends Error {
    constructor(primaryKey) {
        super(`"${primaryKey}" is an invalid primary key value.`);
        this.primaryKey = primaryKey;
    }
}
exports.InvalidPrimaryKeyError = InvalidPrimaryKeyError;
/**
 * Thrown if an invalid value is given as a primary key.
 */
class PrimaryKeyCannotBeModifiedError extends Error {
    constructor(primaryKey) {
        super(`Primary key "${primaryKey}" cannot be modified in update queries.`);
        this.primaryKey = primaryKey;
    }
}
exports.PrimaryKeyCannotBeModifiedError = PrimaryKeyCannotBeModifiedError;
/**
 * Thrown if a table retrieval method expects to find exactly one item, but finds none.
 */
class ItemNotFoundError extends Error {
    constructor(queryOrId) {
        super(`No item found for query "${queryOrId}".`);
        this.queryOrId = queryOrId;
    }
}
exports.ItemNotFoundError = ItemNotFoundError;
/**
 * Thrown if a table retrieval method expects to find exactly one item, but finds more than one.
 */
class MoreThanOneItemFoundError extends Error {
    constructor(queryOrId) {
        super(`More than one item found for query "${queryOrId}".`);
        this.queryOrId = queryOrId;
    }
}
exports.MoreThanOneItemFoundError = MoreThanOneItemFoundError;
