import { Query } from "../query/types";
import { Entity, PrimaryKeyOf } from "../types";
/**
 * Thrown if the primary key of an item being inserted is already present within the table.
 */
export declare class PrimaryKeyAlreadyInUseError<T> extends Error {
    readonly primaryKey: T;
    constructor(primaryKey: T);
}
/**
 * Thrown if an invalid value is given as a primary key.
 */
export declare class InvalidPrimaryKeyError<T> extends Error {
    readonly primaryKey: T;
    constructor(primaryKey: T);
}
/**
 * Thrown if an invalid value is given as a primary key.
 */
export declare class PrimaryKeyCannotBeModifiedError<T> extends Error {
    readonly primaryKey: T;
    constructor(primaryKey: T);
}
/**
 * Thrown if a table retrieval method expects to find exactly one item, but finds none.
 */
export declare class ItemNotFoundError<T extends Entity<T>, P extends PrimaryKeyOf<T>> extends Error {
    readonly queryOrId: Query<T, P> | T[P];
    constructor(queryOrId: Query<T, P> | T[P]);
}
/**
 * Thrown if a table retrieval method expects to find exactly one item, but finds more than one.
 */
export declare class MoreThanOneItemFoundError<T extends Entity<T>, P extends PrimaryKeyOf<T>> extends Error {
    readonly queryOrId: Query<T, P> | T[P];
    constructor(queryOrId: Query<T, P> | T[P]);
}
