"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTable = void 0;
const sorted_btree_1 = __importDefault(require("sorted-btree"));
const Dispatcher_1 = require("../events/Dispatcher");
const createDB_1 = require("./createDB");
function createTable(db, tableName) {
    return (options) => {
        var _a, _b, _c;
        const primaryBTree = new sorted_btree_1.default();
        primaryBTree.totalItemSize = 0;
        return {
            [createDB_1.BlinkKey]: {
                db,
                tableName,
                storage: {
                    primary: primaryBTree,
                    indexes: ((_a = options === null || options === void 0 ? void 0 : options.indexes) !== null && _a !== void 0 ? _a : []).reduce((prev, cur) => {
                        const btree = new sorted_btree_1.default();
                        btree.totalItemSize = 0;
                        return Object.assign(Object.assign({}, prev), { [cur]: btree });
                    }, {}),
                },
                events: {
                    onClear: new Dispatcher_1.Dispatcher(),
                    onInsert: new Dispatcher_1.Dispatcher(),
                    onRemove: new Dispatcher_1.Dispatcher(),
                    onUpdate: new Dispatcher_1.Dispatcher(),
                },
                hooks: [],
                options: {
                    primary: (_b = options === null || options === void 0 ? void 0 : options.primary) !== null && _b !== void 0 ? _b : "id",
                    indexes: (_c = options === null || options === void 0 ? void 0 : options.indexes) !== null && _c !== void 0 ? _c : [],
                },
            },
        };
    };
}
exports.createTable = createTable;
