"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDB = exports.BlinkKey = void 0;
exports.BlinkKey = Symbol("BlinkDB");
/**
 * Creates a new database.
 *
 * Using the `db` object, you can create new tables in which to save your entities.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const taskTable = createTable<Task>(db, "tasks")();
 */
function createDB(options) {
    return {
        [exports.BlinkKey]: {
            options: Object.assign({ clone: true }, options),
            hooks: [],
        },
    };
}
exports.createDB = createDB;
