"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.internalCount = exports.count = void 0;
const Middleware_1 = require("../events/Middleware");
const query_1 = require("../query");
const analyze_1 = require("../query/analyze");
const createDB_1 = require("./createDB");
function count(table, filter, options = { exact: true }) {
    return Promise.resolve((0, Middleware_1.middleware)(table, {
        action: "count",
        params: [table, filter, options],
    }, (table, filter, options) => internalCount(table, filter, options)));
}
exports.count = count;
function internalCount(table, filter, options = { exact: true }) {
    const totalSize = table[createDB_1.BlinkKey].storage.primary.size;
    if (!filter || !filter.where) {
        return Promise.resolve(totalSize);
    }
    if (options.exact) {
        return Promise.resolve((0, query_1.get)(table, filter).length);
    }
    else {
        return Promise.resolve(Math.min((0, analyze_1.analyze)(table, filter.where), totalSize));
    }
}
exports.internalCount = internalCount;
