"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.internalClear = exports.clear = void 0;
const Middleware_1 = require("../events/Middleware");
const createDB_1 = require("./createDB");
/**
 * Removes all entities from `table`.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * await clear(userTable);
 */
function clear(table) {
    return Promise.resolve((0, Middleware_1.middleware)(table, { action: "clear", params: [table] }, (table) => internalClear(table)));
}
exports.clear = clear;
function internalClear(table) {
    table[createDB_1.BlinkKey].storage.primary.clear();
    for (const key in table[createDB_1.BlinkKey].storage.indexes) {
        const btree = table[createDB_1.BlinkKey].storage.indexes[key];
        btree.clear();
        btree.totalItemSize = 0;
    }
    void table[createDB_1.BlinkKey].events.onClear.dispatch();
    return Promise.resolve();
}
exports.internalClear = internalClear;
