import { Entity, PrimaryKeyOf } from "../types";
import { Table } from "./createTable";
/**
 * Removes all entities from `table`.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * await clear(userTable);
 */
export declare function clear<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>): Promise<void>;
export declare function internalClear<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>): Promise<void>;
