"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const happy_dom_1 = require("happy-dom");
/**
 *
 */
class GlobalRegistrator {
    /**
     * Registers Happy DOM globally.
     */
    static register() {
        if (this.registered.length) {
            throw new Error('Failed to register. Happy DOM has already been globally registered.');
        }
        const window = new happy_dom_1.GlobalWindow();
        for (const key of Object.keys(window)) {
            if (global[key] === undefined && key !== 'undefined') {
                global[key] = window[key];
                this.registered.push(key);
            }
        }
    }
    /**
     * Registers Happy DOM globally.
     */
    static unregister() {
        if (!this.registered.length) {
            throw new Error('Failed to unregister. Happy DOM has not previously been globally registered.');
        }
        while (this.registered.length) {
            const key = this.registered.pop();
            delete global[key];
        }
    }
}
GlobalRegistrator.registered = [];
exports.default = GlobalRegistrator;
//# sourceMappingURL=GlobalRegistrator.cjs.map