/**
 * ownCloud Android client application
 *
 * @author Christian Schabesberger
 * Copyright (C) 2022 ownCloud GmbH.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.owncloud.android.domain.webfinger.usecases

import com.owncloud.android.domain.BaseUseCaseWithResult
import com.owncloud.android.domain.webfinger.WebFingerRepository
import com.owncloud.android.domain.webfinger.model.WebFingerRel

class GetOwnCloudInstanceFromWebFingerUseCase(
    private val webfingerRepository: WebFingerRepository
) : BaseUseCaseWithResult<String, GetOwnCloudInstanceFromWebFingerUseCase.Params>() {

    override fun run(params: Params): String =
        webfingerRepository.getInstancesFromWebFinger(
            server = params.server,
            rel = WebFingerRel.OWNCLOUD_INSTANCE,
            resource = params.resource
        ).first()

    data class Params(
        val server: String,
        val resource: String
    )
}
