/* ownCloud Android Library is available under MIT license
 *   Copyright (C) 2022 ownCloud GmbH.
 *
 *   Permission is hereby granted, free of charge, to any person obtaining a copy
 *   of this software and associated documentation files (the "Software"), to deal
 *   in the Software without restriction, including without limitation the rights
 *   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *   copies of the Software, and to permit persons to whom the Software is
 *   furnished to do so, subject to the following conditions:
 *
 *   The above copyright notice and this permission notice shall be included in
 *   all copies or substantial portions of the Software.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 *   BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 *   ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 *   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *   THE SOFTWARE.
 */
package com.owncloud.android.lib.resources.spaces.services

import com.owncloud.android.lib.common.OwnCloudClient
import com.owncloud.android.lib.common.operations.RemoteOperationResult
import com.owncloud.android.lib.resources.spaces.CreateRemoteSpaceOperation
import com.owncloud.android.lib.resources.spaces.DisableRemoteSpaceOperation
import com.owncloud.android.lib.resources.spaces.EditRemoteSpaceImageOperation
import com.owncloud.android.lib.resources.spaces.EditRemoteSpaceOperation
import com.owncloud.android.lib.resources.spaces.EnableRemoteSpaceOperation
import com.owncloud.android.lib.resources.spaces.GetRemoteSpacePermissionsOperation
import com.owncloud.android.lib.resources.spaces.GetRemoteSpacesOperation
import com.owncloud.android.lib.resources.spaces.responses.SpaceResponse

class OCSpacesService(override val client: OwnCloudClient) : SpacesService {
    override fun getSpaces(): RemoteOperationResult<List<SpaceResponse>> =
        GetRemoteSpacesOperation().execute(client)

    override fun createSpace(spaceName: String, spaceSubtitle: String, spaceQuota: Long): RemoteOperationResult<SpaceResponse> =
        CreateRemoteSpaceOperation(spaceName, spaceSubtitle, spaceQuota).execute(client)

    override fun getSpacePermissions(spaceId: String): RemoteOperationResult<List<String>> =
        GetRemoteSpacePermissionsOperation(spaceId).execute(client)

    override fun editSpace(spaceId: String, spaceName: String, spaceSubtitle: String, spaceQuota: Long?): RemoteOperationResult<SpaceResponse> =
        EditRemoteSpaceOperation(spaceId, spaceName, spaceSubtitle, spaceQuota).execute(client)

    override fun editSpaceImage(spaceId: String, imageId: String): RemoteOperationResult<SpaceResponse> =
        EditRemoteSpaceImageOperation(spaceId, imageId).execute(client)

    override fun disableSpace(spaceId: String, deleteMode: Boolean): RemoteOperationResult<Unit> =
        DisableRemoteSpaceOperation(spaceId, deleteMode).execute(client)

    override fun enableSpace(spaceId: String): RemoteOperationResult<SpaceResponse> =
        EnableRemoteSpaceOperation(spaceId).execute(client)

}
