//    Copyright (C) 2015, Mike Rieker, Beverly, MA USA
//    www.outerworldapps.com
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; version 2 of the License.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    EXPECT it to FAIL when someone's HeALTh or PROpeRTy is at RISk.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    http://www.gnu.org/licenses/gpl-2.0.html


/**
 * @brief Diff two files generated by ReadArptDgmPng.cs
 *
 * gmcs -out:DiffArptDgmCsvs.exe DiffArptDgmCsvs.cs
 * mono --debug DiffArptDgmCsvs.exe <file1>.csv <file2>.csv
 *
 * For each diff, verify plate with:
 *   mono --debug ReadArptDgmPng.exe datums/aptdiags_300_20150204/CMH.png -csvoutfile x.csv -csvoutid CMH -markedpng CMH.png
 */

using System;
using System.IO;

public class DiffArptDgmCsvs {
    public static void Main (string[] args)
    {
        string name1 = args[0];
        string name2 = args[1];

        StreamReader file1 = new StreamReader (name1);
        StreamReader file2 = new StreamReader (name2);

        string   line1 = file1.ReadLine ();
        string   line2 = file2.ReadLine ();
        string[] cols1 = line1.Split (',');
        string[] cols2 = line2.Split (',');
        while (true) {
            while (String.Compare (cols1[0], cols2[0]) < 0) {
                Console.WriteLine ("< " + cols1[0]);
                line1 = file1.ReadLine ();
                if (line1 == null) goto eof;
                cols1 = line1.Split (',');
            }
            while (String.Compare (cols1[0], cols2[0]) > 0) {
                Console.WriteLine ("> " + cols2[0]);
                line2 = file2.ReadLine ();
                if (line2 == null) goto eof;
                cols2 = line2.Split (',');
            }
            if (cols1.Length != cols2.Length) {
                Console.WriteLine ("* " + cols1[0]);
            } else {
                for (int i = 0; ++ i < cols1.Length;) {
                    double num1 = Math.Abs (double.Parse (cols1[i]));
                    double num2 = Math.Abs (double.Parse (cols2[i]));
                    if ((num1 < 1.0E-8) && (num2 < 1.0E-8)) continue;
                    double ratio = num1 / num2;
                    if (ratio < 1.0) ratio = num2 / num1;
                    if (ratio < 1.01) continue;
                    Console.WriteLine ("# " + cols1[0] + " " + i + " " + cols1[i] + " " + cols2[i]);
                }
            }
            line1 = file1.ReadLine ();
            line2 = file2.ReadLine ();
            if ((line1 == null) || (line2 == null)) goto eof;
            cols1 = line1.Split (',');
            cols2 = line2.Split (',');
        }
    eof:
        while (line1 != null) {
            cols1 = line1.Split (',');
            Console.WriteLine ("< " + cols1[0]);
            line1 = file1.ReadLine ();
        }
        while (line2 != null) {
            cols2 = line2.Split (',');
            Console.WriteLine ("> " + cols2[0]);
            line2 = file2.ReadLine ();
        }
    }
}
