/*
 * SPDX-FileCopyrightText: 2015 - 2025 Rime community
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

package com.osfans.trime.util

import androidx.navigation.NavController
import androidx.navigation.navOptions
import androidx.navigation.ui.R

fun <T : Any> NavController.navigateWithAnim(route: T) {
    navigate(
        route,
        navOptions {
            anim {
                enter = R.animator.nav_default_enter_anim
                exit = R.animator.nav_default_exit_anim
                popEnter = R.animator.nav_default_pop_enter_anim
                popExit = R.animator.nav_default_pop_exit_anim
            }
        },
    )
}
