package com.orgzly.android.util

import com.orgzly.android.ui.views.style.UrlLinkSpan
import org.hamcrest.CoreMatchers.instanceOf
import org.hamcrest.CoreMatchers.`is`
import org.hamcrest.MatcherAssert.assertThat
import org.junit.Test
import org.junit.runner.RunWith
import org.robolectric.RobolectricTestRunner
import org.robolectric.annotation.Config

@RunWith(RobolectricTestRunner::class)
@Config(sdk = [35])
class OrgFormatterMiscTest : OrgFormatterTest() {

    @Test
    fun testLinksMultiLine() {
        val spannable = ParseResult(
            "[[https://www.orgzlyrevived.com]]\n" +
            "[[https://www.orgzlyrevived.com]]"
        )

        assertThat(spannable.outputString, `is`("https://www.orgzlyrevived.com\nhttps://www.orgzlyrevived.com"))

        assertThat(spannable.foundSpans.size, `is`(2))

        assertThat(spannable.foundSpans[0].start, `is`(0))
        assertThat(spannable.foundSpans[0].end, `is`(29))
        assertThat(spannable.foundSpans[0].span, instanceOf(UrlLinkSpan::class.java))
        assertThat(spannable.foundSpans[0].url, `is`("https://www.orgzlyrevived.com"))

        assertThat(spannable.foundSpans[1].start, `is`(30))
        assertThat(spannable.foundSpans[1].end, `is`(59))
        assertThat(spannable.foundSpans[0].span, instanceOf(UrlLinkSpan::class.java))
        assertThat(spannable.foundSpans[1].url, `is`("https://www.orgzlyrevived.com"))
    }

    @Test
    fun testLinksNamed() {
        val spannable = ParseResult("[[https://www.orgzlyrevived.com][Orgzly]]")

        assertThat(spannable.outputString, `is`("Orgzly"))

        assertThat(spannable.foundSpans.size, `is`(1))

        assertThat(spannable.foundSpans[0].start, `is`(0))
        assertThat(spannable.foundSpans[0].end, `is`(6))
        assertThat(spannable.foundSpans[0].span, instanceOf(UrlLinkSpan::class.java))
        assertThat(spannable.foundSpans[0].url, `is`("https://www.orgzlyrevived.com"))
    }

    @Test
    fun testAllLinkTypes() {
        val spannable = ParseResult(
            "AAA http://www.x.com BBB [[http://www.y.com]]CCC [[http://www.z.com][Z]]DDD"
        )

        assertThat(spannable.outputString, `is`("AAA http://www.x.com BBB http://www.y.comCCC ZDDD"))

        assertThat(spannable.foundSpans.size, `is`(3))

        assertThat(spannable.foundSpans[0].start, `is`(4))
        assertThat(spannable.foundSpans[0].end, `is`(20))
        assertThat(spannable.foundSpans[0].span, instanceOf(UrlLinkSpan::class.java))
        assertThat(spannable.foundSpans[0].url, `is`("http://www.x.com"))

        assertThat(spannable.foundSpans[1].start, `is`(25))
        assertThat(spannable.foundSpans[1].end, `is`(41))
        assertThat(spannable.foundSpans[0].span, instanceOf(UrlLinkSpan::class.java))
        assertThat(spannable.foundSpans[1].url, `is`("http://www.y.com"))

        assertThat(spannable.foundSpans[2].start, `is`(45))
        assertThat(spannable.foundSpans[2].end, `is`(46))
        assertThat(spannable.foundSpans[0].span, instanceOf(UrlLinkSpan::class.java))
        assertThat(spannable.foundSpans[2].url, `is`("http://www.z.com"))
    }

    @Test
    fun testMailto() {
        val spannable = ParseResult(
            "AAA mailto:x@x.com BBB [[mailto:y@y.com]]CCC [[mailto:z@z.com][Z]]DDD"
        )

        assertThat(spannable.outputString, `is`("AAA mailto:x@x.com BBB mailto:y@y.comCCC ZDDD"))

        assertThat(spannable.foundSpans.size, `is`(3))

        assertThat(spannable.foundSpans[0].start, `is`(4))
        assertThat(spannable.foundSpans[0].end, `is`(18))
        assertThat(spannable.foundSpans[0].span, instanceOf(UrlLinkSpan::class.java))
        assertThat(spannable.foundSpans[0].url, `is`("mailto:x@x.com"))

        assertThat(spannable.foundSpans[1].start, `is`(23))
        assertThat(spannable.foundSpans[1].end, `is`(37))
        assertThat(spannable.foundSpans[0].span, instanceOf(UrlLinkSpan::class.java))
        assertThat(spannable.foundSpans[1].url, `is`("mailto:y@y.com"))

        assertThat(spannable.foundSpans[2].start, `is`(41))
        assertThat(spannable.foundSpans[2].end, `is`(42))
        assertThat(spannable.foundSpans[0].span, instanceOf(UrlLinkSpan::class.java))
        assertThat(spannable.foundSpans[2].url, `is`("mailto:z@z.com"))
    }

    @Test
    fun testPlainLinkWithTrailingSlash() {
        val spannable = ParseResult("https://www.orgzlyrevived.com/")
        assertThat(spannable.outputString, `is`("https://www.orgzlyrevived.com/"))
    }
}
