package com.orgzly.android.widgets

import com.orgzly.R

object WidgetColors {
    val colors = mapOf(
        "dynamic" to mapOf(
            R.id.list_widget_header_container to R.attr.colorPrimaryContainer,
            R.id.list_widget_list_container to android.R.attr.colorBackground,
            R.id.list_widget_header_logo to android.R.attr.textColorPrimary,
            R.id.list_widget_header_selection to android.R.attr.textColorPrimary,
            R.id.list_widget_header_selection_arrow to android.R.attr.textColorPrimary,
            R.id.list_widget_header_add to android.R.attr.textColorPrimary,
            R.id.list_widget_empty_view to android.R.attr.textColorPrimary,
            R.id.widget_list_item_divider_value to android.R.attr.textColorPrimary,
            R.id.item_list_widget_title to android.R.attr.textColorPrimary,
            R.id.item_list_widget_book_icon to android.R.attr.textColorSecondary,
            R.id.item_list_widget_book_text to android.R.attr.textColorSecondary,
            R.id.item_list_widget_scheduled_icon to android.R.attr.textColorSecondary,
            R.id.item_list_widget_scheduled_text to android.R.attr.textColorSecondary,
            R.id.item_list_widget_deadline_icon to android.R.attr.textColorSecondary,
            R.id.item_list_widget_deadline_text to android.R.attr.textColorSecondary,
            R.id.item_list_widget_event_icon to android.R.attr.textColorSecondary,
            R.id.item_list_widget_event_text to android.R.attr.textColorSecondary,
            R.id.item_list_widget_closed_icon to android.R.attr.textColorSecondary,
            R.id.item_list_widget_closed_text to android.R.attr.textColorSecondary,
            R.id.item_list_widget_done to android.R.attr.textColorSecondary
        ),
        "light" to mapOf(
            R.id.list_widget_header_container to R.color.widget_light_header_bg_color,
            R.id.list_widget_list_container to R.color.widget_light_list_bg_color,
            R.id.list_widget_header_logo to R.color.widget_light_header_text_color,
            R.id.list_widget_header_selection to R.color.widget_light_header_text_color,
            R.id.list_widget_header_selection_arrow to R.color.widget_light_header_text_color,
            R.id.list_widget_header_add to R.color.widget_light_header_text_color,
            R.id.list_widget_empty_view to R.color.widget_light_title_color,
            R.id.widget_list_item_divider_value to R.color.widget_light_title_color,
            R.id.item_list_widget_title to R.color.widget_light_title_color,
            R.id.item_list_widget_book_icon to R.color.widget_light_post_title_color,
            R.id.item_list_widget_book_text to R.color.widget_light_post_title_color,
            R.id.item_list_widget_scheduled_icon to R.color.widget_light_post_title_color,
            R.id.item_list_widget_scheduled_text to R.color.widget_light_post_title_color,
            R.id.item_list_widget_deadline_icon to R.color.widget_light_post_title_color,
            R.id.item_list_widget_deadline_text to R.color.widget_light_post_title_color,
            R.id.item_list_widget_event_icon to R.color.widget_light_post_title_color,
            R.id.item_list_widget_event_text to R.color.widget_light_post_title_color,
            R.id.item_list_widget_closed_icon to R.color.widget_light_post_title_color,
            R.id.item_list_widget_closed_text to R.color.widget_light_post_title_color,
            R.id.item_list_widget_done to R.color.widget_light_post_title_color
        ),
        "dark" to mapOf(
            R.id.list_widget_header_container to R.color.widget_dark_header_bg_color,
            R.id.list_widget_list_container to R.color.widget_dark_list_bg_color,
            R.id.list_widget_header_logo to R.color.widget_dark_header_text_color,
            R.id.list_widget_header_selection to R.color.widget_dark_header_text_color,
            R.id.list_widget_header_selection_arrow to R.color.widget_dark_header_text_color,
            R.id.list_widget_header_add to R.color.widget_dark_header_text_color,
            R.id.list_widget_empty_view to R.color.widget_dark_title_color,
            R.id.widget_list_item_divider_value to R.color.widget_dark_title_color,
            R.id.item_list_widget_title to R.color.widget_dark_title_color,
            R.id.item_list_widget_book_icon to R.color.widget_dark_post_title_color,
            R.id.item_list_widget_book_text to R.color.widget_dark_post_title_color,
            R.id.item_list_widget_scheduled_icon to R.color.widget_dark_post_title_color,
            R.id.item_list_widget_scheduled_text to R.color.widget_dark_post_title_color,
            R.id.item_list_widget_deadline_icon to R.color.widget_dark_post_title_color,
            R.id.item_list_widget_deadline_text to R.color.widget_dark_post_title_color,
            R.id.item_list_widget_event_icon to R.color.widget_dark_post_title_color,
            R.id.item_list_widget_event_text to R.color.widget_dark_post_title_color,
            R.id.item_list_widget_closed_icon to R.color.widget_dark_post_title_color,
            R.id.item_list_widget_closed_text to R.color.widget_dark_post_title_color,
            R.id.item_list_widget_done to R.color.widget_dark_post_title_color,
        ),
        "black" to mapOf(
            R.id.list_widget_header_container to R.color.widget_black_header_bg_color,
            R.id.list_widget_list_container to R.color.widget_black_list_bg_color,
            R.id.list_widget_header_logo to R.color.widget_black_header_text_color,
            R.id.list_widget_header_selection to R.color.widget_black_header_text_color,
            R.id.list_widget_header_selection_arrow to R.color.widget_black_header_text_color,
            R.id.list_widget_header_add to R.color.widget_black_header_text_color,
            R.id.list_widget_empty_view to R.color.widget_black_title_color,
            R.id.widget_list_item_divider_value to R.color.widget_black_title_color,
            R.id.item_list_widget_title to R.color.widget_black_title_color,
            R.id.item_list_widget_book_icon to R.color.widget_black_post_title_color,
            R.id.item_list_widget_book_text to R.color.widget_black_post_title_color,
            R.id.item_list_widget_scheduled_icon to R.color.widget_black_post_title_color,
            R.id.item_list_widget_scheduled_text to R.color.widget_black_post_title_color,
            R.id.item_list_widget_deadline_icon to R.color.widget_black_post_title_color,
            R.id.item_list_widget_deadline_text to R.color.widget_black_post_title_color,
            R.id.item_list_widget_event_icon to R.color.widget_black_post_title_color,
            R.id.item_list_widget_event_text to R.color.widget_black_post_title_color,
            R.id.item_list_widget_closed_icon to R.color.widget_black_post_title_color,
            R.id.item_list_widget_closed_text to R.color.widget_black_post_title_color,
            R.id.item_list_widget_done to R.color.widget_black_post_title_color,
        )
    )

    val dataDependentColors = mapOf(
        "dynamic-day" to mapOf(
            "todo" to R.color.widget_light_state_todo_color,
            "done" to R.color.widget_light_state_done_color,
            "post title" to R.color.widget_light_post_title_color,
        ),
        "dynamic-night" to mapOf(
            "todo" to R.color.widget_dark_state_todo_color,
            "done" to R.color.widget_dark_state_done_color,
            "post title" to R.color.widget_dark_post_title_color,
        ),
        "light" to mapOf(
            "todo" to R.color.widget_light_state_todo_color,
            "done" to R.color.widget_light_state_done_color,
            "post title" to R.color.widget_light_post_title_color,
        ),
        "dark" to mapOf(
            "todo" to R.color.widget_dark_state_todo_color,
            "done" to R.color.widget_dark_state_done_color,
            "post title" to R.color.widget_dark_post_title_color,
        ),
        "black" to mapOf(
            "todo" to R.color.widget_black_state_todo_color,
            "done" to R.color.widget_black_state_done_color,
            "post title" to R.color.widget_black_post_title_color,
        )
    )
}