"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ensureNativeModuleAvailable", {
  enumerable: true,
  get: function () {
    return _ensureNativeModuleAvailable.ensureNativeModuleAvailable;
  }
});
exports.getImageForFont = getImageForFont;
exports.getImageForFontSync = getImageForFontSync;
var _reactNative = require("react-native");
var _ensureNativeModuleAvailable = require("./ensure-native-module-available.js");
const LINKING_ERROR = `
  The package '@react-native-vector-icons/get-image' doesn't seem to be linked. Make sure:
    ${_reactNative.Platform.select({
  ios: "- You have run 'pod install'\n",
  default: ''
})}
    - You rebuilt the app after installing the package\n'
    - You are not using Expo Go
  `;

// eslint-disable-next-line @typescript-eslint/no-require-imports
const VectorIconsModule = require('./NativeVectorIcons').default;
const VectorIcons = VectorIconsModule ? VectorIconsModule : new Proxy({}, {
  get() {
    throw new Error(LINKING_ERROR);
  }
});
function getImageForFont(fontFamilyName, glyph, fontSize, color) {
  return VectorIcons.getImageForFont(fontFamilyName, glyph, fontSize, color);
}
function getImageForFontSync(fontFamilyName, glyph, fontSize, color) {
  return VectorIcons.getImageForFontSync(fontFamilyName, glyph, fontSize, color);
}
//# sourceMappingURL=index.js.map