"use strict";

import fs from 'node:fs';
import path from 'node:path';
import { findUpSync } from 'find-up';

/**
 * Source vendored and simplified from @react-native-coommunity/cli
 */
const resolveNodeModuleDir = (root, pkgName) => {
  const packageDir = findUpSync(path.join('node_modules', pkgName), {
    cwd: root,
    type: 'directory'
  });
  return packageDir;
};
const getPackageJson = filename => {
  const packageData = fs.readFileSync(filename, 'utf-8');
  const packageJson = JSON.parse(packageData);
  return packageJson;
};
const getPackageFontDirectories = packageJsonFilename => {
  const rootPackageJson = getPackageJson(packageJsonFilename);
  const dependencies = Object.keys(rootPackageJson.dependencies || {});
  const packageDirs = [];
  dependencies.forEach(dependency => {
    const dir = resolveNodeModuleDir(packageJsonFilename, dependency);
    const packageJson = getPackageJson(`${dir}/package.json`);
    if (packageJson.keywords?.includes?.('react-native-vector-icons-icon')) {
      packageDirs.push(`${dir}/fonts`);
    }
  });
  return packageDirs;
};
const getLocalFontsDir = packageJsonFilename => {
  const rootPackageJson = getPackageJson(packageJsonFilename);
  const config = rootPackageJson.reactNativeVectorIcons || {};
  return `${path.dirname(packageJsonFilename)}/${config.fontDir || 'rnvi-fonts'}`;
};
const getFonts = fontDir => {
  if (!fs.existsSync(fontDir)) {
    return [];
  }
  const fonts = fs.readdirSync(fontDir);
  const fontPaths = fonts.map(font => `${fontDir}/${font}`);
  return fontPaths;
};
export const getFontPaths = packageJsonFilename => {
  const packageDirs = getPackageFontDirectories(packageJsonFilename);
  packageDirs.push(getLocalFontsDir(packageJsonFilename));
  const fonts = packageDirs.map(getFonts);
  return fonts.flat();
};
//# sourceMappingURL=common.js.map