"use strict";

// eslint-disable-next-line import/no-extraneous-dependencies
import React, { forwardRef, useEffect } from 'react';
// eslint-disable-next-line import/no-extraneous-dependencies
import { Platform, Text } from 'react-native';
import createIconSourceCache from "./create-icon-source-cache.js";
import { DEFAULT_ICON_COLOR, DEFAULT_ICON_SIZE } from "./defaults.js";
import { dynamicLoader } from "./dynamicLoading/dynamic-font-loading.js";
import { isDynamicLoadingEnabled } from "./dynamicLoading/dynamic-loading-setting.js";
import { getImageSource as getImageSourceImpl, getImageSourceSync as getImageSourceSyncImpl } from "./get-image-source.js";
import { jsxs as _jsxs, jsx as _jsx } from "react/jsx-runtime";
export function createIconSet(glyphMap, postScriptNameOrOptions, fontFileNameParam, fontStyleParam) {
  const {
    postScriptName,
    fontFileName,
    fontStyle
  } = typeof postScriptNameOrOptions === 'string' ? {
    postScriptName: postScriptNameOrOptions,
    fontFileName: fontFileNameParam,
    fontStyle: fontStyleParam
  } : postScriptNameOrOptions;
  const fontBasename = fontFileName ? fontFileName.replace(/\.(otf|ttf)$/, '') : postScriptName;
  const fontReference = Platform.select({
    windows: `/Assets/${fontFileName}#${postScriptName}`,
    android: fontBasename,
    default: postScriptName
  });
  const styleOverrides = {
    fontFamily: fontReference,
    fontWeight: 'normal',
    fontStyle: 'normal'
  };
  const resolveGlyph = name => {
    const glyph = glyphMap[name];
    if (typeof glyph === 'number') {
      return String.fromCodePoint(glyph);
    }
    return '?';
  };
  const Icon = ({
    name,
    size = DEFAULT_ICON_SIZE,
    color = DEFAULT_ICON_COLOR,
    style,
    children,
    allowFontScaling = false,
    innerRef,
    ...props
  }) => {
    const [isFontLoaded, setIsFontLoaded] = React.useState(isDynamicLoadingEnabled() ? dynamicLoader.isLoaded(fontReference) : true);
    const glyph = isFontLoaded && name ? resolveGlyph(name) : '';

    // biome-ignore lint/correctness/useExhaustiveDependencies: the dependencies never change
    useEffect(() => {
      let isMounted = true;
      if (!isFontLoaded && typeof postScriptNameOrOptions === 'object' && typeof postScriptNameOrOptions.fontSource !== 'undefined') {
        dynamicLoader.loadFontAsync(fontReference, postScriptNameOrOptions.fontSource).finally(() => {
          if (isMounted) {
            setIsFontLoaded(true);
          }
        });
      }
      return () => {
        isMounted = false;
      };
    }, []);
    const styleDefaults = {
      fontSize: size,
      color
    };
    const newProps = {
      ...props,
      style: [styleDefaults, style, styleOverrides, fontStyle || {}],
      allowFontScaling
    };
    return /*#__PURE__*/_jsxs(Text, {
      ref: innerRef,
      selectable: false,
      ...newProps,
      children: [glyph, children]
    });
  };
  const WrappedIcon = /*#__PURE__*/forwardRef((props, ref) => /*#__PURE__*/_jsx(Icon, {
    innerRef: ref,
    ...props
  }));
  WrappedIcon.displayName = `Icon(${postScriptName})`;
  const imageSourceCache = createIconSourceCache();
  const getImageSource = async (name, size, color) => {
    if (typeof postScriptNameOrOptions === 'object' && typeof postScriptNameOrOptions.fontSource !== 'undefined') {
      await dynamicLoader.loadFontAsync(fontReference, postScriptNameOrOptions.fontSource);
    }
    return getImageSourceImpl(imageSourceCache, fontReference, resolveGlyph(name), size, color);
  };
  const getImageSourceSync = (name, size, color) => getImageSourceSyncImpl(imageSourceCache, fontReference, resolveGlyph(name), size, color);
  const IconNamespace = Object.assign(WrappedIcon, {
    getImageSource,
    getImageSourceSync
  });
  return IconNamespace;
}
//# sourceMappingURL=create-icon-set.js.map