"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getImageSourceSync = exports.getImageSource = void 0;
var _reactNative = require("react-native");
var _defaults = require("./defaults.js");
var _getImageLibrary = require("./get-image-library.js");
const getImageSourceSync = (imageSourceCache, fontReference, glyph, size = _defaults.DEFAULT_ICON_SIZE, color = _defaults.DEFAULT_ICON_COLOR) => {
  const NativeIconAPI = (0, _getImageLibrary.ensureGetImageAvailable)();
  const processedColor = (0, _reactNative.processColor)(color);
  const cacheKey = `${glyph}:${size}:${String(processedColor)}`;
  const maybeCachedValue = imageSourceCache.get(cacheKey);
  if (maybeCachedValue !== undefined) {
    // FIXME: Should this check if it's an error and throw it again?
    return maybeCachedValue;
  }
  try {
    const imagePath = NativeIconAPI.getImageForFontSync(fontReference, glyph, size, processedColor // FIXME what if a non existent colour was passed in?
    );
    const value = {
      uri: imagePath,
      scale: _reactNative.PixelRatio.get()
    };
    imageSourceCache.setValue(cacheKey, value);
    return value;
  } catch (error) {
    imageSourceCache.setError(cacheKey, error);
    throw error;
  }
};
exports.getImageSourceSync = getImageSourceSync;
const getImageSource = async (imageSourceCache, fontReference, glyph, size = _defaults.DEFAULT_ICON_SIZE, color = _defaults.DEFAULT_ICON_COLOR) => {
  const NativeIconAPI = (0, _getImageLibrary.ensureGetImageAvailable)();
  const processedColor = (0, _reactNative.processColor)(color);
  const cacheKey = `${glyph}:${size}:${String(processedColor)}`;
  const maybeCachedValue = imageSourceCache.get(cacheKey);
  if (maybeCachedValue !== undefined) {
    // FIXME: Should this check if it's an error and throw it again?
    return maybeCachedValue;
  }
  try {
    const imagePath = await NativeIconAPI.getImageForFont(fontReference, glyph, size, processedColor // FIXME what if a non existent colour was passed in?
    );
    const value = {
      uri: imagePath,
      scale: _reactNative.PixelRatio.get()
    };
    imageSourceCache.setValue(cacheKey, value);
    return value;
  } catch (error) {
    imageSourceCache.setError(cacheKey, error);
    throw error;
  }
};
exports.getImageSource = getImageSource;
//# sourceMappingURL=get-image-source.js.map