"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertExpoModulesPresent = assertExpoModulesPresent;
exports.getErrorCallback = void 0;
exports.getIsRenderToImageSupported = getIsRenderToImageSupported;
exports.setDynamicLoadingErrorCallback = exports.setDynamicLoadingEnabled = exports.isDynamicLoadingSupported = exports.isDynamicLoadingEnabled = void 0;
var _reactNative = require("react-native");
// this is a file:// uri on native, or an object with uri and display on web

// biome-ignore lint/suspicious/noExplicitAny: this is used internally with globalThis
function getIsDynamicLoadingSupported(globalObj) {
  return globalObj?.expo && (_reactNative.Platform.OS === 'web' || typeof globalObj.expo.modules?.ExpoAsset?.downloadAsync === 'function') && typeof globalObj.expo.modules?.ExpoFontLoader?.getLoadedFonts === 'function' && typeof globalObj.expo.modules?.ExpoFontLoader?.loadAsync === 'function';
}

// biome-ignore lint/suspicious/noExplicitAny: this is used internally with globalThis
function getIsRenderToImageSupported(globalObj) {
  return globalObj?.expo && typeof globalObj.expo.modules?.ExpoFontUtils?.renderToImageAsync === 'function';
}
function assertExpoModulesPresent(globalObj) {
  if (!getIsDynamicLoadingSupported(globalObj)) {
    throw new Error('Dynamic font loading not supported. Upgrade to latest expo and expo-font.');
  }
}
const hasNecessaryExpoModules = (_reactNative.Platform.OS === 'web' || !!globalThis.expo?.modules?.ExpoAsset) && !!globalThis.expo?.modules?.ExpoFontLoader;
const hasNecessaryExpoFeatures = getIsDynamicLoadingSupported(globalThis);
let dynamicFontLoadingEnabled = hasNecessaryExpoFeatures;
const isDynamicLoadingSupported = () => hasNecessaryExpoFeatures;

/**
 * Set whether dynamic loading of fonts is enabled.
 * Currently, the presence of Expo Asset and Font Loader modules is a prerequisite for enabling.
 * In the future, React Native core apis will be used for dynamic font loading.
 *
 * @param value - whether dynamic loading of fonts is enabled
 * @returns `true` if dynamic loading of fonts was successfully set. `false` otherwise.
 * */
exports.isDynamicLoadingSupported = isDynamicLoadingSupported;
const setDynamicLoadingEnabled = value => {
  if (!hasNecessaryExpoFeatures) {
    if (process.env.NODE_ENV !== 'production' && !!value) {
      const message = hasNecessaryExpoModules ? 'Expo is installed, but does not support dynamic font loading. Make sure to use Expo SDK 54 or newer.' : 'Necessary Expo modules not found. Dynamic font loading is not available when necessary Expo modules are not present.';
      console.error(message); // eslint-disable-line no-console
    }
    return false;
  }
  dynamicFontLoadingEnabled = !!value;
  return true;
};

/**
 * Whether dynamic loading of fonts is enabled.
 * */
exports.setDynamicLoadingEnabled = setDynamicLoadingEnabled;
const isDynamicLoadingEnabled = () => dynamicFontLoadingEnabled;
exports.isDynamicLoadingEnabled = isDynamicLoadingEnabled;
let dynamicLoadingErrorCallback;

/**
 * Set a callback to be called when an error occurs during dynamic font loading.
 * */
const setDynamicLoadingErrorCallback = callback => {
  dynamicLoadingErrorCallback = callback;
};
exports.setDynamicLoadingErrorCallback = setDynamicLoadingErrorCallback;
const getErrorCallback = () => dynamicLoadingErrorCallback;
exports.getErrorCallback = getErrorCallback;
//# sourceMappingURL=dynamic-loading-setting.js.map