export type RoundingProps = {
    step: number;
    minimumValue: number;
    maximumValue: number;
};
/**
 * Provide a rounding method given the provided slider configuration.
 * The results will be rounded, with the minimum amount of digits, and
 * we make sure that it still fits within the bounds.
*/
declare const useRounding: ({ step, minimumValue, maximumValue }: RoundingProps) => (value: number) => number;
export default useRounding;
