type Props = {
    step: number;
    range: [number, number];
    minimumRange: number;
    minimumValue: number;
    maximumValue: number;
    slideOnTap?: boolean;
    crossingAllowed?: boolean;
    onValueChange?: (range: [number, number]) => boolean | void;
};
/** Handle the state of a range slider */
declare const useRange: ({ step, range: propValue, minimumRange, minimumValue, maximumValue, slideOnTap, onValueChange, crossingAllowed }: Props) => {
    updateMinValue: (newValue: number) => void;
    updateMaxValue: (newValue: number) => void;
    updateClosestValue: (value: number, state: "press" | "release" | "drag") => number[];
    canMove: (value: number) => boolean;
    range: [number, number];
};
export default useRange;
