"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useEvent = useEvent;
const react_1 = __importDefault(require("react"));
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function useEvent(onEvent) {
    const onEventRef = react_1.default.useRef(onEvent);
    onEventRef.current = onEvent;
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const staticOnEvent = react_1.default.useCallback((...args) => {
        const currentOnEvent = onEventRef.current;
        return currentOnEvent(...args);
    }, []);
    return staticOnEvent;
}
