"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(require("react"));
const useEvent_1 = require("./useEvent");
/** Creates the interactions with the slider */
const useDrag = ({ value, canMove, updateValue, onSlidingStart, onSlidingComplete }) => {
    // Emit the events onSlidingStart and onSlidingComplete when we start / stop sliding
    const [sliding, setSliding] = react_1.default.useState(false);
    const onPress = (0, useEvent_1.useEvent)((newValue) => {
        if (!canMove(newValue))
            return;
        onSlidingStart === null || onSlidingStart === void 0 ? void 0 : onSlidingStart(value);
        setSliding(true);
        updateValue(newValue, 'press');
    });
    const onRelease = (0, useEvent_1.useEvent)((newValue) => {
        if (!sliding)
            return;
        setSliding(false);
        updateValue(newValue, 'release');
    });
    // The useEffect cannot depend on value, so we need this function
    const fireSlidingComplete = (0, useEvent_1.useEvent)(() => onSlidingComplete === null || onSlidingComplete === void 0 ? void 0 : onSlidingComplete(value));
    // Each time "sliding" switches from "true" to "false", we want to fire the event "complete" with the latest value (after update)
    react_1.default.useEffect(() => {
        if (sliding)
            return fireSlidingComplete;
    }, [fireSlidingComplete, sliding]);
    const onMove = (0, useEvent_1.useEvent)((value) => {
        if (sliding)
            updateValue(value, 'drag');
    });
    return { onPress, onRelease, onMove };
};
exports.default = useDrag;
