type Props<T extends number | [number, number]> = {
    value: T;
    onSlidingStart?: (value: T) => void;
    onSlidingComplete?: (value: T) => void;
    updateValue: (value: number, state: 'press' | 'release' | 'drag') => void;
    canMove: (value: number) => boolean;
};
/** Creates the interactions with the slider */
declare const useDrag: <T extends number | [number, number]>({ value, canMove, updateValue, onSlidingStart, onSlidingComplete }: Props<T>) => {
    onPress: (newValue: number) => void;
    onRelease: (newValue: number) => void;
    onMove: (value: number) => void;
};
export default useDrag;
