"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(require("react"));
const react_native_1 = require("react-native");
const useRounding_1 = __importDefault(require("./useRounding"));
const styleSheet = react_native_1.StyleSheet.create({
    mark: {
        position: 'absolute',
        alignItems: 'center',
        justifyContent: 'center',
        width: 0,
        height: 0,
        pointerEvents: 'none',
        zIndex: 1,
        overflow: 'visible'
    }
});
const Mark = ({ CustomMark, left, top, ...props }) => {
    const style = react_1.default.useMemo(() => ([styleSheet.mark, { top, left }]), [top, left]);
    return react_1.default.createElement(react_native_1.View, { style: style },
        react_1.default.createElement(CustomMark, { ...props }));
};
const useCustomMarks = (CustomMark, { step, minimumValue, maximumValue, activeValues, thumbRadius = 0, inverted, vertical }) => {
    const [sliderWidth, setSliderWidth] = react_1.default.useState(0);
    const [sliderHeight, setSliderHeight] = react_1.default.useState(0);
    const onLayoutUpdateMarks = react_1.default.useCallback((event) => {
        const { width, height } = event.nativeEvent.layout;
        setSliderWidth(width);
        setSliderHeight(height);
    }, []);
    const round = (0, useRounding_1.default)({ step, minimumValue, maximumValue });
    const marks = react_1.default.useMemo(() => {
        if (!CustomMark)
            return [];
        const markCount = Math.round((maximumValue - minimumValue) / (step || 1)) + 1;
        return Array(markCount).fill(0).map((_, index) => {
            const markValue = round(index * step + minimumValue);
            const advance = ((vertical ? sliderHeight : sliderWidth) - thumbRadius) * (markValue - minimumValue) / ((maximumValue - minimumValue) || 1) + thumbRadius / 2;
            const padding = (vertical ? sliderWidth : sliderHeight) / 2;
            const x = inverted ? (vertical ? sliderHeight : sliderWidth) - advance : advance;
            const y = padding;
            return react_1.default.createElement(Mark, { key: markValue, CustomMark: CustomMark, value: markValue, active: activeValues.includes(markValue), top: vertical ? x : y, left: vertical ? y : x });
        });
    }, [CustomMark, activeValues, inverted, maximumValue, minimumValue, round, sliderHeight, sliderWidth, step, thumbRadius, vertical]);
    return { marks, onLayoutUpdateMarks };
};
exports.default = useCustomMarks;
