"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.THUMB_SIZE = void 0;
const react_1 = __importDefault(require("react"));
const RN = __importStar(require("react-native"));
const useEvent_1 = require("../hooks/useEvent");
// without a size, the thumb becomes impossible to select with key navigation
exports.THUMB_SIZE = 1;
const stylesheet = RN.StyleSheet.create({
    container: {
        width: exports.THUMB_SIZE,
        height: exports.THUMB_SIZE,
        justifyContent: 'center',
        alignItems: 'center',
        overflow: 'visible',
        zIndex: 2
    }
});
function getThumbContainerStyle(size) {
    // This is used for feedback on focus on the thumb.
    // On custom Thumb component, we prefer to ignore the size instruction
    const sizeDetails = size
        ? {
            width: size,
            height: size,
            borderRadius: size / 2
        }
        : undefined;
    return RN.StyleSheet.create({
        thumbContainer: {
            ...sizeDetails,
            justifyContent: 'center',
            alignItems: 'center',
            overflow: 'visible',
            zIndex: 3
        }
    }).thumbContainer;
}
function getThumbStyle(size, color) {
    return RN.StyleSheet.create({
        thumb: {
            width: size,
            height: size,
            backgroundColor: color,
            borderRadius: size / 2,
            overflow: 'hidden',
            elevation: 2,
            zIndex: 10
        }
    }).thumb;
}
const accessibility = [
    { name: 'increment', label: 'increment' },
    { name: 'decrement', label: 'decrement' }
];
const Thumb = ({ color = 'darkcyan', CustomThumb, size = 15, style, thumbImage, thumb, value, minimumValue, maximumValue, step, updateValue }) => {
    const thumbContainerStyle = react_1.default.useMemo(() => getThumbContainerStyle(CustomThumb ? undefined : size), [CustomThumb, size]);
    const thumbViewStyle = react_1.default.useMemo(() => [getThumbStyle(size, color), style], [style, size, color]);
    // Accessibility actions
    const accessibilityActions = (0, useEvent_1.useEvent)((event) => {
        const tenth = (maximumValue - minimumValue) / 10;
        switch (event.nativeEvent.actionName) {
            case 'increment':
                updateValue(value + (step || tenth));
                break;
            case 'decrement':
                updateValue(value - (step || tenth));
                break;
        }
    });
    const handleAccessibilityKeys = (0, useEvent_1.useEvent)((event) => {
        const key = event.nativeEvent.key;
        switch (key) {
            case 'ArrowUp':
            case 'ArrowRight':
                {
                    const accessibilityEvent = { ...event, nativeEvent: { actionName: 'increment' } };
                    accessibilityActions(accessibilityEvent);
                }
                break;
            case 'ArrowDown':
            case 'ArrowLeft':
                {
                    const accessibilityEvent = { ...event, nativeEvent: { actionName: 'decrement' } };
                    accessibilityActions(accessibilityEvent);
                }
                break;
        }
    });
    const accessibilityValues = react_1.default.useMemo(() => {
        // Accessibility values cannot be decimal
        const isDecimal = value % 1 !== 0 || minimumValue % 1 !== 0 || maximumValue % 1 !== 0 || step % 1 !== 0 || (step === 0 && ((maximumValue - minimumValue) / 10) % 1 !== 0);
        return isDecimal ? { min: 0, max: 100, now: Math.round(value / ((maximumValue - minimumValue) || 1) * 100) } : { min: minimumValue, max: maximumValue, now: value };
    }, [value, minimumValue, maximumValue, step]);
    return react_1.default.createElement(RN.View, { style: stylesheet.container },
        react_1.default.createElement(RN.View, { accessibilityActions: accessibility, onAccessibilityAction: accessibilityActions, focusable: true, accessible: true, accessibilityValue: accessibilityValues, accessibilityRole: 'adjustable', accessibilityLabel: thumb, 
            // This is for web
            // eslint-disable-next-line @typescript-eslint/ban-ts-comment
            // @ts-ignore
            onKeyDown: handleAccessibilityKeys, style: thumbContainerStyle }, thumbImage ? react_1.default.createElement(RN.Image, { source: thumbImage, style: thumbViewStyle }) : CustomThumb ? react_1.default.createElement(CustomThumb, { value: value, thumb: thumb }) : react_1.default.createElement(RN.View, { style: thumbViewStyle })));
};
exports.default = react_1.default.memo(Thumb);
