"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(require("react"));
const react_native_1 = require("react-native");
const useRounding_1 = __importDefault(require("../hooks/useRounding"));
const useEvent_1 = require("../hooks/useEvent");
const Thumb_1 = require("./Thumb");
const styleSheet = react_native_1.StyleSheet.create({
    container: {
        position: 'absolute',
        left: 0,
        height: '100%',
        width: '100%',
        top: 0,
        margin: 'auto',
        overflow: 'visible'
    },
    mark: {
        alignItems: 'center',
        justifyContent: 'center',
        width: 0,
        height: 0,
        pointerEvents: 'none',
        zIndex: 1,
        overflow: 'visible'
    }
});
const Mark = ({ StepMarker, left, top, ...props }) => {
    const style = react_1.default.useMemo(() => ([styleSheet.mark, { top, left }]), [top, left]);
    return react_1.default.createElement(react_native_1.View, { style: style },
        react_1.default.createElement(StepMarker, { ...props }));
};
const Marks = (props) => {
    const { StepMarker, step, minimumValue, maximumValue, inverted, vertical, activeValue } = props;
    const [sliderWidth, setSliderWidth] = react_1.default.useState(0);
    const [sliderHeight, setSliderHeight] = react_1.default.useState(0);
    const onLayoutUpdateMarks = (0, useEvent_1.useEvent)((event) => {
        const { width, height } = event.nativeEvent.layout;
        setSliderWidth(width);
        setSliderHeight(height);
    });
    const round = (0, useRounding_1.default)({ step, minimumValue, maximumValue });
    const marks = react_1.default.useMemo(() => {
        // We cannot render marks if there is no step as we cannot render an infinite amount of marks
        if (!StepMarker || !step)
            return null;
        const markCount = Math.round((maximumValue - minimumValue) / step) + 1;
        return Array(markCount).fill(0).map((_, index) => {
            const markValue = round(index * step + minimumValue);
            const advance = ((vertical ? sliderHeight : sliderWidth) - Thumb_1.THUMB_SIZE) * (markValue - minimumValue) / ((maximumValue - minimumValue) || 1) + Thumb_1.THUMB_SIZE / 2;
            const padding = (vertical ? sliderWidth : sliderHeight) / 2;
            const x = inverted ? (vertical ? sliderHeight : sliderWidth) - advance : advance;
            const y = padding;
            return react_1.default.createElement(Mark, { key: markValue, StepMarker: StepMarker, stepMarked: Array.isArray(activeValue) ? activeValue.includes(markValue) : activeValue === markValue, currentValue: activeValue, markValue: markValue, index: index, min: minimumValue, max: maximumValue, top: vertical ? x : y, left: vertical ? y : x });
        });
    }, [StepMarker, activeValue, inverted, maximumValue, minimumValue, round, sliderHeight, sliderWidth, step, vertical]);
    return react_1.default.createElement(react_native_1.View, { style: styleSheet.container, onLayout: onLayoutUpdateMarks }, marks);
};
exports.default = Marks;
