import React from 'react';
type SliderType = 'slider' | 'range';
type SliderValue<T extends SliderType> = T extends 'slider' ? number : [number, number];
export type CustomMarkType<T extends 'slider' | 'range'> = React.ComponentType<{
    stepMarked: boolean;
    currentValue: SliderValue<T>;
    index: number;
    min: number;
    max: number;
    markValue: number;
}>;
type CustomMarksProps<T extends 'slider' | 'range'> = {
    StepMarker?: CustomMarkType<T>;
    minimumValue: number;
    maximumValue: number;
    step: number;
    activeValue: SliderValue<T>;
    type: T;
    inverted: boolean;
    vertical: boolean;
};
declare const Marks: <T extends "slider" | "range">(props: CustomMarksProps<T>) => React.JSX.Element;
export default Marks;
