"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(require("react"));
const useThumb_1 = __importDefault(require("./hooks/useThumb"));
const Track_1 = __importDefault(require("./components/Track"));
const Thumb_1 = __importDefault(require("./components/Thumb"));
const ResponderView_1 = __importDefault(require("./components/ResponderView"));
const useDrag_1 = __importDefault(require("./hooks/useDrag"));
const Marks_1 = __importDefault(require("./components/Marks"));
const Slider = react_1.default.forwardRef((props, forwardedRef) => {
    const { step = 0, minimumValue = 0, maximumValue = minimumValue + step, value: propValue = minimumValue, minimumTrackTintColor = 'grey', maximumTrackTintColor = 'grey', thumbTintColor = 'darkcyan', thumbStyle, trackStyle, minTrackStyle, maxTrackStyle, inverted = false, vertical = false, enabled = true, slideOnTap = true, trackHeight = 4, thumbSize = 15, thumbImage, onValueChange, onSlidingStart, onSlidingComplete, CustomThumb, CustomTrack, StepMarker, ...others } = props;
    const { updateValue, value, canMove } = (0, useThumb_1.default)({
        minimumValue,
        maximumValue,
        value: propValue,
        step,
        slideOnTap,
        onValueChange
    });
    const { onPress, onMove, onRelease } = (0, useDrag_1.default)({ value, canMove, updateValue, onSlidingComplete, onSlidingStart });
    const percentage = react_1.default.useMemo(() => (value - minimumValue) / ((maximumValue - minimumValue) || 1), [value, minimumValue, maximumValue]);
    const [minStyle, maxStyle] = react_1.default.useMemo(() => [minTrackStyle, maxTrackStyle].map(style => (style && trackStyle) ? [style, trackStyle] : (style || trackStyle)), [trackStyle, minTrackStyle, maxTrackStyle]);
    const thumbProps = {
        color: thumbTintColor,
        style: thumbStyle,
        size: thumbSize,
        CustomThumb: CustomThumb,
        thumbImage,
        minimumValue,
        maximumValue,
        step
    };
    const trackProps = {
        thickness: trackHeight,
        // We pretend to accept "mid" as value for track, but we don't use it
        CustomTrack: CustomTrack,
        vertical
    };
    const marksProps = { StepMarker, step, minimumValue, maximumValue, activeValue: value, inverted, vertical };
    return (react_1.default.createElement(ResponderView_1.default, { ...others, ref: forwardedRef, maximumValue: maximumValue, minimumValue: minimumValue, step: step, onPress: onPress, onMove: onMove, onRelease: onRelease, enabled: enabled, vertical: vertical, inverted: inverted },
        react_1.default.createElement(Track_1.default, { ...trackProps, color: minimumTrackTintColor, style: minStyle, length: percentage * 100, track: 'min' }),
        react_1.default.createElement(Thumb_1.default, { ...thumbProps, updateValue: updateValue, value: value }),
        react_1.default.createElement(Track_1.default, { ...trackProps, color: maximumTrackTintColor, style: maxStyle, length: (1 - percentage) * 100, track: 'max' }),
        react_1.default.createElement(Marks_1.default, { type: 'slider', ...marksProps })));
});
Slider.displayName = 'Slider';
exports.default = react_1.default.memo(Slider);
