import React from 'react';
import * as RN from 'react-native';
import { CustomMarkType } from './components/Marks';
export type SliderProps = RN.ViewProps & {
    value?: number;
    minimumValue?: number;
    maximumValue?: number;
    step?: number;
    minimumTrackTintColor?: RN.ColorValue;
    maximumTrackTintColor?: RN.ColorValue;
    thumbTintColor?: RN.ColorValue;
    thumbStyle?: RN.StyleProp<RN.ViewStyle>;
    trackStyle?: RN.StyleProp<RN.ViewStyle>;
    minTrackStyle?: RN.StyleProp<RN.ViewStyle>;
    maxTrackStyle?: RN.StyleProp<RN.ViewStyle>;
    style?: RN.StyleProp<RN.ViewStyle>;
    inverted?: boolean;
    vertical?: boolean;
    enabled?: boolean;
    slideOnTap?: boolean;
    trackHeight?: number;
    thumbSize?: number;
    thumbImage?: RN.ImageURISource;
    onValueChange?: (value: number) => boolean | void;
    onSlidingStart?: (value: number) => void;
    onSlidingComplete?: (value: number) => void;
    CustomThumb?: React.ComponentType<{
        value: number;
    }>;
    StepMarker?: CustomMarkType<'slider'>;
    CustomTrack?: React.ComponentType<{
        length: number;
        thickness: number;
        vertical: boolean;
        track: 'min' | 'max';
        style: RN.StyleProp<RN.ViewStyle>;
        color: RN.ColorValue;
    }>;
};
declare const _default: React.MemoExoticComponent<React.ForwardRefExoticComponent<RN.ViewProps & {
    value?: number;
    minimumValue?: number;
    maximumValue?: number;
    step?: number;
    minimumTrackTintColor?: RN.ColorValue;
    maximumTrackTintColor?: RN.ColorValue;
    thumbTintColor?: RN.ColorValue;
    thumbStyle?: RN.StyleProp<RN.ViewStyle>;
    trackStyle?: RN.StyleProp<RN.ViewStyle>;
    minTrackStyle?: RN.StyleProp<RN.ViewStyle>;
    maxTrackStyle?: RN.StyleProp<RN.ViewStyle>;
    style?: RN.StyleProp<RN.ViewStyle>;
    inverted?: boolean;
    vertical?: boolean;
    enabled?: boolean;
    slideOnTap?: boolean;
    trackHeight?: number;
    thumbSize?: number;
    thumbImage?: RN.ImageURISource;
    onValueChange?: (value: number) => boolean | void;
    onSlidingStart?: (value: number) => void;
    onSlidingComplete?: (value: number) => void;
    CustomThumb?: React.ComponentType<{
        value: number;
    }>;
    StepMarker?: CustomMarkType<"slider">;
    CustomTrack?: React.ComponentType<{
        length: number;
        thickness: number;
        vertical: boolean;
        track: "min" | "max";
        style: RN.StyleProp<RN.ViewStyle>;
        color: RN.ColorValue;
    }>;
} & React.RefAttributes<RN.View>>>;
export default _default;
